# AI + Cursor 开发一个肺活量测试器

## 开发过程直播回放

点击观看：[直播教程回放](https://www.codefather.cn/live/1904453120491511810?tab=desc)

## 开发技巧

1）推荐用 Linux 或 Mac 系统（或者 Windows 装 WSL），执行终端命令更方便 => 或者在上下文中告诉 AI：使用 Windows 系统的终端命令

2）有的时候 AI 会因为缺少上下文信息导致陷入循环，一旦发现循环，建议人工介入（可以问下别的 AI）

3）建议大家创建新项目时，用最复杂的（最高级的）推理模型

4）注意如果文件没有自动保存，可以手动保存一下（在文件管理器中检查）。或者在 File 选项中设置自动保存

5）建议利用 Git 对代码进行管理，防止 AI 生成代码有误时，因为编辑器错误导致老代码无法复原

6）如果单一的大模型无法正常完成工作，可以利用其他 AI 生成“教 AI 做事的方法和指令”

## 开发技巧

1）首先用 Agent 模式，粘贴需求分析文案，让 AI 自助生成网站，直到能够运行

2）能够成功运行后，进行测试，并且依次完成每个功能（这个阶段需要不断调试）

## 需求分析

**一、目标用户**

- 普通用户: 关注自身健康状况，希望了解自身肺功能水平。
- 健身爱好者: 监测训练效果，评估心肺功能。
- 医疗机构: 辅助诊断呼吸系统疾病，跟踪患者康复情况。

**二、核心功能**

1）【P0】肺活量测试。用户根据提示进行吹气，网站通过麦克风获取数据。

2）数据可视化: 实时显示吹气曲线、峰值流速、肺活量值等。

3）结果评估: 根据年龄、性别、身高、体重等生成肺活量指数，提供健康建议，比如运动、饮食等方面的建议。

4）保存用户测试记录，生成历史数据图表，支持查看趋势图。

5）提供健康小知识：可以查看肺健康相关知识，如肺活量提升方法、呼吸系统疾病预防等。

6）社交分享: 支持用户生成测试结果的分享卡片，可以保存为图片

- 学习 Cursor 不写代码开发项目的方法
- 学习提示词的使用技巧
- 学习一些编程方面的小知识

---

加入编程导航，获取 10+ 套原创企业级实战项目，可以直接写进简历：

https://yuyuanweb.feishu.cn/wiki/VC1qwmX9diCBK3kidyec74vFnde